/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.block;

import java.util.Random;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.entity.EntityBlock;
import net.jayjay.dangerzone.entity.EntityParticle;
import net.jayjay.dangerzone.particle.ParticleEngine;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.world.World;

public class Block {
    public final String blockTag;
    public String texturePath;
    public String breaksound;
    public String placesound;
    public String material;

    public Block(String tag) {
        this.blockTag = tag;
        this.breaksound = "dz2:breakBlock";
        this.placesound = "dz2:placeBlock";
        this.material = "dz2:material_stone";
        ++Blocks.blockLimit;
    }

    public Block(String tag, String tex) {
        this(tag);
        this.texturePath = tex;
    }

    public void render(Tesselator tess, World level, int layer, int x, int y, int z) {
        float topBrightness = 1.0f;
        float sideBrightness1 = 0.8f;
        float sideBrightness2 = 0.6f;
        if (this.shouldRenderFace(level, x, y - 1, z, layer, 0)) {
            tess.setColor(topBrightness, topBrightness, topBrightness);
            this.renderFace(tess, x, y, z, 0);
        }
        if (this.shouldRenderFace(level, x, y + 1, z, layer, 1)) {
            tess.setColor(topBrightness, topBrightness, topBrightness);
            this.renderFace(tess, x, y, z, 1);
        }
        if (this.shouldRenderFace(level, x, y, z - 1, layer, 2)) {
            tess.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
            this.renderFace(tess, x, y, z, 2);
        }
        if (this.shouldRenderFace(level, x, y, z + 1, layer, 3)) {
            tess.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
            this.renderFace(tess, x, y, z, 3);
        }
        if (this.shouldRenderFace(level, x - 1, y, z, layer, 4)) {
            tess.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
            this.renderFace(tess, x, y, z, 4);
        }
        if (this.shouldRenderFace(level, x + 1, y, z, layer, 5)) {
            tess.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
            this.renderFace(tess, x, y, z, 5);
        }
    }

    protected boolean shouldRenderFace(World world, int x, int y, int z, int layer, int face) {
        if (!this.shouldCullFace(face)) {
            return world.isLit(x, y, z) ^ layer == 1;
        }
        int adjacentBlockId = world.getBlock(x, y, z);
        Block adjacentBlock = Blocks.getBlockById(adjacentBlockId);
        int cullingMode = this.getCullingMode();
        if (cullingMode == 0) {
            return !world.isSolidBlock(x, y, z) && world.isLit(x, y, z) ^ layer == 1;
        }
        if (cullingMode == 1) {
            boolean shouldCull;
            boolean bl = shouldCull = adjacentBlock != null && adjacentBlock.blockTag.equals(this.blockTag);
            return !shouldCull && world.isLit(x, y, z) ^ layer == 1;
        }
        if (cullingMode == 2) {
            return world.isLit(x, y, z) ^ layer == 1;
        }
        return !world.isSolidBlock(x, y, z) && world.isLit(x, y, z) ^ layer == 1;
    }

    public boolean shouldCullFace(int face) {
        return true;
    }

    public int getCullingMode() {
        return 0;
    }

    public boolean hasCustomModel() {
        return false;
    }

    public String getTexturePath(int face) {
        return this.texturePath;
    }

    public void renderFace(Tesselator tess, int x, int y, int z, int face) {
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float x0 = (float)x + 0.0f;
        float x1 = (float)x + 1.0f;
        float y0 = (float)y + 0.0f;
        float y1 = (float)y + 1.0f;
        float z0 = (float)z + 0.0f;
        float z1 = (float)z + 1.0f;
        if (face == 0) {
            tess.addVertexWithUV(x0, y0, z1, u0, v1);
            tess.addVertexWithUV(x0, y0, z0, u0, v0);
            tess.addVertexWithUV(x1, y0, z0, u1, v0);
            tess.addVertexWithUV(x1, y0, z1, u1, v1);
        }
        if (face == 1) {
            tess.addVertexWithUV(x1, y1, z1, u1, v1);
            tess.addVertexWithUV(x1, y1, z0, u1, v0);
            tess.addVertexWithUV(x0, y1, z0, u0, v0);
            tess.addVertexWithUV(x0, y1, z1, u0, v1);
        }
        if (face == 2) {
            tess.addVertexWithUV(x0, y1, z0, u1, v0);
            tess.addVertexWithUV(x1, y1, z0, u0, v0);
            tess.addVertexWithUV(x1, y0, z0, u0, v1);
            tess.addVertexWithUV(x0, y0, z0, u1, v1);
        }
        if (face == 3) {
            tess.addVertexWithUV(x0, y1, z1, u0, v0);
            tess.addVertexWithUV(x0, y0, z1, u0, v1);
            tess.addVertexWithUV(x1, y0, z1, u1, v1);
            tess.addVertexWithUV(x1, y1, z1, u1, v0);
        }
        if (face == 4) {
            tess.addVertexWithUV(x0, y1, z1, u1, v0);
            tess.addVertexWithUV(x0, y1, z0, u0, v0);
            tess.addVertexWithUV(x0, y0, z0, u0, v1);
            tess.addVertexWithUV(x0, y0, z1, u1, v1);
        }
        if (face == 5) {
            tess.addVertexWithUV(x1, y0, z1, u0, v1);
            tess.addVertexWithUV(x1, y0, z0, u1, v1);
            tess.addVertexWithUV(x1, y1, z0, u1, v0);
            tess.addVertexWithUV(x1, y1, z1, u0, v0);
        }
    }

    public void renderFaceNoTexture(Tesselator t, int x, int y, int z, int face) {
        float x0 = (float)x + 0.0f;
        float x1 = (float)x + 1.0f;
        float y0 = (float)y + 0.0f;
        float y1 = (float)y + 1.0f;
        float z0 = (float)z + 0.0f;
        float z1 = (float)z + 1.0f;
        if (face == 0) {
            t.addVertex(x0, y0, z1);
            t.addVertex(x0, y0, z0);
            t.addVertex(x1, y0, z0);
            t.addVertex(x1, y0, z1);
        }
        if (face == 1) {
            t.addVertex(x1, y1, z1);
            t.addVertex(x1, y1, z0);
            t.addVertex(x0, y1, z0);
            t.addVertex(x0, y1, z1);
        }
        if (face == 2) {
            t.addVertex(x0, y1, z0);
            t.addVertex(x1, y1, z0);
            t.addVertex(x1, y0, z0);
            t.addVertex(x0, y0, z0);
        }
        if (face == 3) {
            t.addVertex(x0, y1, z1);
            t.addVertex(x0, y0, z1);
            t.addVertex(x1, y0, z1);
            t.addVertex(x1, y1, z1);
        }
        if (face == 4) {
            t.addVertex(x0, y1, z1);
            t.addVertex(x0, y1, z0);
            t.addVertex(x0, y0, z0);
            t.addVertex(x0, y0, z1);
        }
        if (face == 5) {
            t.addVertex(x1, y0, z1);
            t.addVertex(x1, y0, z0);
            t.addVertex(x1, y1, z0);
            t.addVertex(x1, y1, z1);
        }
    }

    public AABB getTileAABB(int x, int y, int z) {
        return new AABB(x, y, z, x + 1, y + 1, z + 1);
    }

    public AABB getAABB(int x, int y, int z) {
        return new AABB(x, y, z, x + 1, y + 1, z + 1);
    }

    public boolean blocksLight() {
        return true;
    }

    public boolean isSolid() {
        return true;
    }

    public boolean isPlant() {
        return false;
    }

    public boolean isExplosionResistant() {
        return false;
    }

    public boolean isRightClickable() {
        return false;
    }

    public void onBlockPlaced(World world, int x, int y, int z) {
    }

    public int getBlockDrop(World world, int x, int y, int z) {
        return Blocks.getBlockID(this.blockTag);
    }

    public int getItemDrop(World world, int x, int y, int z) {
        return 0;
    }

    public int getDropCount(World world, int x, int y, int z) {
        return 1;
    }

    public String getBlockSounds(String blockTag) {
        return this.breaksound;
    }

    public String getMaterial(String blockTag) {
        return this.material;
    }

    public void onRightClick(World world, int x, int y, int z) {
        System.out.println("right clicked right clickable block");
    }

    public void tick(World world, int x, int y, int z, Random random) {
    }

    public void destroy(World world, int x, int y, int z, ParticleEngine particleEngine) {
        int SD = 8;
        int xx = 0;
        while (xx < SD) {
            int yy = 0;
            while (yy < SD) {
                int zz = 0;
                while (zz < SD) {
                    float xp = (float)x + ((float)xx + 0.5f) / (float)SD;
                    float yp = (float)y + ((float)yy + 0.5f) / (float)SD;
                    float zp = (float)z + ((float)zz + 0.5f) / (float)SD;
                    particleEngine.add(new EntityParticle(world, xp, yp, zp, xp - (float)x - 0.5f, yp - (float)y - 0.5f, zp - (float)z - 0.5f, this.texturePath));
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
        world.entities.add(new EntityBlock(DZ2.getInstance().world, x, y, z, this, this.getDropCount(world, x, y, z)));
    }
}

